/* Defines for the Atmega 328p */


#ifndef ATMEGA328_H_
#define ATMEGA328_H_

/* Port B */
//data direction register
#define pinModeB DDRB

#define PB0_input 0B00000000
#define PB1_input 0B00000000
#define PB2_input 0B00000000
#define PB3_input 0B00000000
#define PB4_input 0B00000000
#define PB5_input 0B00000000
#define PB6_input 0B00000000
#define PB7_input 0B00000000

#define PB0_output 0B00000001
#define PB1_output 0B00000010
#define PB2_output 0B00000100
#define PB3_output 0B00001000
#define PB4_output 0B00010000
#define PB5_output 0B00100000
#define PB6_output 0B01000000
#define PB7_output 0B10000000

//data register
#define digitalWriteB PORTB

#define PB0_low 0B0000000
#define PB1_low 0B0000000
#define PB2_low 0B0000000
#define PB3_low 0B0000000
#define PB4_low 0B0000000
#define PB5_low 0B0000000
#define PB6_low 0B0000000
#define PB7_low 0B0000000

#define PB0_high 0B00000001
#define PB1_high 0B00000010
#define PB2_high 0B00000100
#define PB3_high 0B00001000
#define PB4_high 0B00010000
#define PB5_high 0B00100000
#define PB6_high 0B01000000
#define PB7_high 0B10000000

/* Port C */
//data direction register
#define pinModeC DDRC

#define PC0_input 0B00000000
#define PC1_input 0B00000000
#define PC2_input 0B00000000
#define PC3_input 0B00000000
#define PC4_input 0B00000000
#define PC5_input 0B00000000
#define PC6_input 0B00000000
#define PC7_input 0B00000000

#define PC0_output 0B00000001
#define PC1_output 0B00000010
#define PC2_output 0B00000100
#define PC3_output 0B00001000
#define PC4_output 0B00010000
#define PC5_output 0B00100000
#define PC6_output 0B01000000
#define PC7_output 0B10000000

//data register
#define digitalWriteC PORTC

#define PC0_low 0B0000000
#define PC1_low 0B0000000
#define PC2_low 0B0000000
#define PC3_low 0B0000000
#define PC4_low 0B0000000
#define PC5_low 0B0000000
#define PC6_low 0B0000000
#define PC7_low 0B0000000

#define PC0_high 0B00000001
#define PC1_high 0B00000010
#define PC2_high 0B00000100
#define PC3_high 0B00001000
#define PC4_high 0B00010000
#define PC5_high 0B00100000
#define PC6_high 0B01000000
#define PC7_high 0B10000000

/* Port D */
//data direction register
#define pinModeD DDRD

#define PD0_input 0B00000000
#define PD1_input 0B00000000
#define PD2_input 0B00000000
#define PD3_input 0B00000000
#define PD4_input 0B00000000
#define PD5_input 0B00000000
#define PD6_input 0B00000000
#define PD7_input 0B00000000

#define PD0_output 0B00000001
#define PD1_output 0B00000010
#define PD2_output 0B00000100
#define PD3_output 0B00001000
#define PD4_output 0B00010000
#define PD5_output 0B00100000
#define PD6_output 0B01000000
#define PD7_output 0B10000000

//data register
#define digitalWriteD PORTD

#define PD0_low 0B0000000
#define PD1_low 0B0000000
#define PD2_low 0B0000000
#define PD3_low 0B0000000
#define PD4_low 0B0000000
#define PD5_low 0B0000000
#define PD6_low 0B0000000
#define PD7_low 0B0000000

#define PD0_high 0B00000001
#define PD1_high 0B00000010
#define PD2_high 0B00000100
#define PD3_high 0B00001000
#define PD4_high 0B00010000
#define PD5_high 0B00100000
#define PD6_high 0B01000000
#define PD7_high 0B10000000

/* Timer 1 */
//TCCR1A register
#define TIMER1A TCCR1A
//pin behavior of OC1A in Output Compare Mode
#define OC1ANormal 0B00000000
#define OC1AToggle 0B01000000
#define OC1ALow 0B10000000
#define OC1AHigh 0B11000000
//pin behavior of OC1B in Output Compare Mode
#define OC2ANormal 0B00000000
#define OC2AToggle 0B00010000
#define OC2ALow 0B00100000
#define OC2AHigh 0B00110000

//TCCR1B register
#define TIMER1B TCCR1B
//clock prescalers
#define prescaler1024 0B00000101
#define prescaler256 0B00000100
#define prescaler64 0B00000011
#define prescaler8 0B00000010
#define prescaler1 0B00000001
#define noclock 0B00000000 //timer/counter stopped
//extra options
#define inputCaptureNoiseCanceler 0B10000000
#define inputCaptureEdgeSelect 0B01000000
//Max value of counter before overflow
#define CTC_OCR1A 0B00001000 //0CR1A
#define CTC_ICR1 0B00011000 //ICR1
#define CTC_normal 0B00000000 //max value

//TIMSK1 register
#define TIMER1INTERRUPT TIMSK1
//when to trigger interrupt
#define Interrupt_inputCapture 0B00010000
#define Interrupt_outputCompareA 0B00000010
#define Interrupt_outputCompareB 0B00000100
#define Interrupt_overflow 0B00000001


/*SPI*/
//SPI Control Register
#define SPI_Control_Register SPCR

#define SPI_Interrupt_Enable 0B10000000
#define SPI_Interrupt_Disable 0B00000000

#define SPI_Enable 0B01000000

#define SPI_LSB 0B00100000
#define SPI_MSB 0B00000000

#define SPI_Master 0B00010000
#define SPI_Slave 0B00000000

#define SPI_Mode_00 0B00000000
#define SPI_Mode_11 0B00001100

#define SPI_fosc4 0B00000000
#define SPI_fosc16 0B00000001
#define SPI_fosc64 0B00000010
#define SPI_fosc128 0B00000011

//SPI status register
#define SPI_Status_Register SPSR

#define SPI_Interrupt_Flag 0B10000000
#define SPI_Double_Speed 0B00000001


//SPI Data Register
#define SPI_Data_Register SPDR


/*LEDSTRIP*/
#define ledframestart  0b11100000
#define brightness 0b00011111

#define zerosbyte 0b00000000
#define onesbyte 0b11111111

#define numberOfLeds  60
#define numberOfPositions 120 // = 360/restheta
#define restheta 3 // Resolution in degrees

#define thetastart 276; // Compensation in degrees for the position of the magnet


/*SOFTWARE SPI*/
#define softspi_clk_DDR DDRD
#define softspi_clk_PORT PORTD
#define softspi_clk_MSK (1<<3)
#define softspi_MOSI_DDR DDRD
#define softspi_MOSI_PORT PORTD
#define softspi_MOSI_MSK (1<<4)

#define MISO 0

/*GENERAL*/
#define F_CPU 16000000UL


#endif /* ATMEGA328_H_ */